﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace Kolekcja2Xml
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        }

        List<Osoba> listaOsob = new List<Osoba> 
        { 
            new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", 
                        NumerTelefonu = 7272024, Wiek = 37 }, 
            new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", 
                        NumerTelefonu = 7272020, Wiek = 38 },
            new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", 
                        NumerTelefonu = 7272021, Wiek = 9 }, 
            new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", 
                        NumerTelefonu = 7272022, Wiek = 4 } 
        };

        private void button1_Click(object sender, EventArgs e)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0","utf-8","yes"),
                new XElement("ListaOsob",
                    from osoba in listaOsob
                    orderby osoba.Wiek
                    select new XElement("Osoba",
                        new XAttribute("Id", osoba.Id),
                        new XElement("Imię", osoba.Imię),
                        new XElement("Nazwisko", osoba.Nazwisko),
                        new XElement("NumerTelefonu", osoba.NumerTelefonu),
                        new XElement("Wiek", osoba.Wiek)
                        )
                )
            );

            xml.Save(@"\Temp\Telefony.xml");      
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //pobieranie danych
            XDocument xml = XDocument.Load(@"\Temp\Telefony.xml");
            IEnumerable<Osoba> listaOsobPelnoletnich =
               from osoba in xml.Descendants("Osoba")
               where int.Parse(osoba.Element("Wiek").Value) >= 18
               orderby osoba.Element("Imię").Value
               select
                  new Osoba()
                  {
                      Id = int.Parse(osoba.Attribute("Id").Value),
                      Imię = osoba.Element("Imię").Value,
                      Nazwisko = osoba.Element("Nazwisko").Value,
                      NumerTelefonu = int.Parse(osoba.Element("NumerTelefonu").Value),
                      Wiek = int.Parse(osoba.Element("Wiek").Value)
                  };

            //wyświetlanie danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //pobieranie danych
            XDocument xml = XDocument.Load(@"\Temp\Telefony.xml");
            IEnumerable<string> listaOsobPelnoletnich =
               from osoba in xml.Descendants("Osoba")
               where int.Parse(osoba.Element("Wiek").Value) >= 18
               orderby osoba.Element("Imię").Value
               select osoba.Element("Imię").Value + " " + osoba.Element("Nazwisko").Value;

            //wyświetlanie danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (string personalia in listaOsobPelnoletnich) s += personalia + "\n";
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load(@"\Temp\Telefony.xml");
            IEnumerable<XElement> listaOsob = xml.Descendants("Osoba").Where(osoba => (osoba.Element("Imię").Value == "Bartosz" && osoba.Element("Nazwisko").Value == "Matulewski"));
            if (listaOsob.Count() > 0) listaOsob.First().Element("Wiek").Value = (int.Parse(listaOsob.First().Element("Wiek").Value) + 1).ToString();
            else
            {
                MessageBox.Show("Brak osób o podanym imieniu i nazwisku");
                return;
            }
            xml.Save(@"\Temp\Telefony.xml");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load(@"\Temp\Telefony.xml");
            IEnumerable<Osoba> listaOsobPelnoletnich =
               from osoba in xml.Descendants("Osoba")                              
               select
                  new Osoba()
                  {
                      Id = int.Parse(osoba.Attribute("Id").Value),
                      Imię = osoba.Element("Imię").Value,
                      Nazwisko = osoba.Element("Nazwisko").Value,
                      NumerTelefonu = int.Parse(osoba.Element("NumerTelefonu").Value),
                      Wiek = int.Parse(osoba.Element("Wiek").Value)
                  };
            string s = "Lista osób:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }
    }
}